
require 'sketchup.rb'
require 'Phlatboyz/Constants.rb'
require 'Phlatboyz/Tools/CenterLineCut.rb'

module PhlatScript

  class CenterLineTool < PhlatTool
    @@D = 1 # Depth Factor Index
    @@override_factor = 0
    @cut_edges = []
    @connected_edges = false

    def initialize
      super
      @connected_edges = false
      @@override_factor = PhlatScript.get_fold_depth_factor() #  TODO change to centerline depth factor ?
    end

    def reset(view)
      self.compute_fold_depth_factor()
      PhlatScript.display_fold_depth_factor()
      @connected_edges = false
      @cut_edges = []
      super
    end

    def onMouseMove(flags, x, y, view)
      if ((@ip.pick view, x, y) && (!@ip.edge.nil?) && ((flags & 1) == 1))
        # left mouse button is down        
        addEdges(collect_edges(@ip.edge))
        view.tooltip = @ip.tooltip
      end
      view.invalidate
    end

    def onLButtonDown(flags, x, y, view)
      if (!@ip.edge.nil?)
        addEdges(collect_edges(@ip.edge))
      else
        view.model.selection.clear
      end
    end

    def onLButtonUp(flags, x, y, view)
      cuts = CenterLineCut.cut(view.model.selection)
      cuts.each { |cut| cut.cut_factor = compute_fold_depth_factor }
      view.model.selection.clear
      view.lock_inference
    end

    def onKeyDown(key, repeat, flags, view)
      refresh = false
      if(key > 47 && key < 58) # number keys
        @@override_factor *= 10
        @@override_factor += (key - 48)
        #@@override_factor %= 100
        refresh = true
      elsif key == 13 # enter key
        @@override_factor = 0
        refresh = true
      elsif key == 68 # D key
        @@D += 1
        @@override_factor = 0
        refresh = true
      elsif key == CONSTRAIN_MODIFIER_KEY
        @connected_edges = true
        refresh = true
      end
      if refresh
        PhlatScript.set_fold_depth_factor(self.compute_fold_depth_factor())
        PhlatScript.display_fold_depth_factor()
        view.invalidate
      end
    end

    def onKeyUp(key, repeat, flags, view)
      if key == CONSTRAIN_MODIFIER_KEY
        @connected_edges = false
        view.invalidate
      end
    end

    def onCancel(reason, view)
      Sketchup.undo if (reason == 2) # user did Undo
      self.reset(view)
    end

    def draw(view)
      CenterLineCut.preview(view, collect_edges(@ip.edge)) if !@ip.edge.nil?
    end

    def addEdge(edge)
      if ((Sketchup.active_model.selection.contains?(edge)) || (edge.nil?))
        return false
      else  
        Sketchup.active_model.selection.add(edge)
        return true
      end
    end

    def addEdges(edges=[])
      edges.each{ |e| addEdge(e) }
    end

    def compute_fold_depth_factor
      if @@override_factor != 0
        fold_depth = @@override_factor
      else
        fold_depth = $fold_depth_factor_array[@@D % $fold_depth_factor_array.length]
      end
      return fold_depth
    end

    def cut_class
      return CenterLineCut
    end

    def statusText
      return "Select edges. Shift to select all connected edges."
    end

    private

    def collect_edges(edge)
      ar = []
      if !@connected_edges
        # if not getting connected edges just add the passed in edge
        ar.push(edge) if (!edge.phlatedge?)
      else
        collect_connected_edges(edge, ar, false)
      end
      return ar
    end

  end

end
